<?php

namespace \App\Models\Application;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'application_user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function application()
    {
        return $this->belongsTo('App\Models\Application');
    }

    public function role()
    {
        return $this->hasOne('\App\Models\Application\User\Role');
    }

    public function acl()
    {
        return $this->hasMany('\App\Models\Application\User\Role\Acl', 'application_user_role_id', 'application_user_role_id');
    }

}